Puls3.Collections.ArticlesCollection = Backbone.Collection.extend({
    model: Puls3.Models.ArticleModel,
    url:"",
    name: "articles",
    search : function(letters){
        if(letters == "") return this;
        var pattern = new RegExp(letters,"gi");
        return _(this.filter(function(data) {
            return pattern.test(data.get("name"));
        }));
    },
    comparator : function(item){
        return item.get("name");    
    },
    getOne : function(id){
        return this.filter(function(data) {
            return data.get("id") == id;
        });
    },
    parse : function(resp) {
        return resp.data;
    }
});

Puls3.Collections.articles = Puls3.Collections.ArticlesCollection;