#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

typedef struct QUOTE {
    char name[20];
    char buf[256];
} the_quote, *the_pquote;

the_pquote store_quote(the_pquote quotes, int *index) {
    if (*index >= 10) {
        printf("Storage is full. Cannot store more quotes.\n");
        return quotes;
    }

    char name[20] = {0};
    char buf[256] = {0};

    printf("[+] Enter your name: \n");
    scanf("%s", name);
    printf("[+] Enter your quote: \n");
    scanf(" %[^\n]s", buf); // This will allow capturing multi-word quotes

    strcpy(quotes[*index].name, name);
    strcpy(quotes[*index].buf, buf);
    (*index)++;

    printf("[+] Quote stored successfully!\n");

    return quotes;
}

void read_quote_by_index(the_pquote quotes, int index) {
    if (index <= 0) {
        printf("No quotes stored yet.\n");
        return;
    }

    int quote_index;
    printf("[+] Enter the index of the quote to read (0 to %d): \n", index - 1);
    scanf("%d", &quote_index);

    if (quote_index >= 0 && quote_index < index) {
        printf("Quote by ");
        printf(quotes[quote_index].name);
        printf(": ");
        printf(quotes[quote_index].buf);
        printf("\n");
    } else {
        printf("Invalid index. Please try again.\n");
    }
}

int main() {
    the_pquote quotes = (the_pquote)malloc(sizeof(the_quote) * 10);
    int index = 0;
    int choice;

    while (true) {
        printf("\n1. Store Quote\n2. Read Quote by Index\n3. Exit\nChoose an option: \n");
        scanf("%d", &choice);

        switch (choice) {
            case 1:
                quotes = store_quote(quotes, &index);
                break;
            case 2:
                read_quote_by_index(quotes, index);
                break;
            case 3:
                free(quotes);
                exit(0);
                break;
            default:
                printf("Invalid choice. Try again.\n");
                exit(0);
                break;
        }
    }

    return 0;
}
